# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 2
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR2_strategy.txt
# LLM Suggested Fallback: D

def benevolent_ally(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:
        return "C"
    
    total_rounds = 10
    current_round = len(my_history)
    
    # Analyze opponent's code for simplicity
    is_always_c = "return \"C\"" in opponent_program_code or "always_cooperate" in opponent_program_code.lower()
    is_always_d = "return \"D\"" in opponent_program_code or "always_defect" in opponent_program_code.lower()
    
    if is_always_c:
        return "D"
    if is_always_d:
        return "C"
    
    # Check if opponent is always cooperating
    if all(move == "C" for move in opp_history):
        if current_round % 3 == 0:
            return "D"
        else:
            return "C"
    
    # Retaliate if opponent defected last round
    if opp_history[-1] == "D":
        return "D"
    
    # Last 2 rounds: defect unless opponent is fully cooperative
    if current_round >= total_rounds - 2:
        if all(move == "C" for move in opp_history):
            return "C"
        else:
            return "D"
    
    return "C"